/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.gates;

import at.petrak.hexcasting.api.utils.NBTHelper;
import com.mojang.datafixers.util.Either;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.casting.iota.GateIota;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\b\u001a\u00020\u00072 \u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\f\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\b\u0010\u000fJ#\u0010\b\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\fH\u0007\u00a2\u0006\u0004\b\b\u0010\u0010J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\b\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u001f\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0016J\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001d8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u001fR&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\"0!8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lram/talia/hexal/api/gates/GateManager;", "", "", "gate", "", "clearMarked", "(I)V", "Lram/talia/hexal/api/casting/iota/GateIota;", "makeGate", "()Lram/talia/hexal/api/casting/iota/GateIota;", "Lcom/mojang/datafixers/util/Either;", "Lnet/minecraft/class_243;", "Lkotlin/Pair;", "Lnet/minecraft/class_1297;", "target", "(Lcom/mojang/datafixers/util/Either;)Lram/talia/hexal/api/casting/iota/GateIota;", "(Lkotlin/Pair;)Lram/talia/hexal/api/casting/iota/GateIota;", "(Lnet/minecraft/class_243;)Lram/talia/hexal/api/casting/iota/GateIota;", "Ljava/util/UUID;", "entity", "mark", "(ILjava/util/UUID;)V", "(ILnet/minecraft/class_1297;)V", "Lnet/minecraft/class_2487;", "tag", "readFromNbt", "(Lnet/minecraft/class_2487;)V", "unmark", "writeToNbt", "", "TAG_CURRENT_GATE_NUM", "Ljava/lang/String;", "TAG_MARKED", "", "", "allMarked", "Ljava/util/Map;", "currentGateNum", "I", "", "shouldClearOnWrite", "Z", "<init>", "()V", "hexal-fabric-1.20.1"})
public final class GateManager {
    @NotNull
    public static final GateManager INSTANCE = new GateManager();
    private static int currentGateNum;
    @JvmField
    public static boolean shouldClearOnWrite;
    @JvmField
    @NotNull
    public static final Map<Integer, Set<UUID>> allMarked;
    @NotNull
    public static final String TAG_CURRENT_GATE_NUM = "hexal:current_gate_num";
    @NotNull
    public static final String TAG_MARKED = "hexal:marked";

    private GateManager() {
    }

    @JvmStatic
    public static final void mark(int gate, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = entity.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uuid");
        GateManager.mark(gate, uUID);
    }

    @JvmStatic
    public static final void mark(int gate, @NotNull UUID entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        allMarked.putIfAbsent(gate, new LinkedHashSet());
        Set<UUID> set = allMarked.get(gate);
        Intrinsics.checkNotNull(set);
        set.add(entity);
    }

    @JvmStatic
    public static final void unmark(int gate, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = entity.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uuid");
        GateManager.unmark(gate, uUID);
    }

    @JvmStatic
    public static final void unmark(int gate, @NotNull UUID entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Set<UUID> set = allMarked.get(gate);
            if (set == null) break block0;
            set.remove(entity);
        }
    }

    @JvmStatic
    public static final void clearMarked(int gate) {
        allMarked.remove(gate);
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate() {
        return INSTANCE.makeGate(null);
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate(@NotNull class_243 target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return INSTANCE.makeGate((Either<class_243, Pair<class_1297, class_243>>)Either.left((Object)target));
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate(@NotNull Pair<? extends class_1297, ? extends class_243> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return INSTANCE.makeGate((Either<class_243, Pair<class_1297, class_243>>)Either.right(target));
    }

    private final GateIota makeGate(Either<class_243, Pair<class_1297, class_243>> target) {
        GateIota gate = new GateIota(currentGateNum, target);
        ++currentGateNum;
        return gate;
    }

    @JvmStatic
    public static final void readFromNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.method_10545(TAG_CURRENT_GATE_NUM)) {
            currentGateNum = tag.method_10550(TAG_CURRENT_GATE_NUM);
        }
        if (tag.method_10545(TAG_MARKED)) {
            class_2487 markedTag = tag.method_10562(TAG_MARKED);
            for (String gateStr : markedTag.method_10541()) {
                Intrinsics.checkNotNullExpressionValue((Object)gateStr, (String)"gateStr");
                Integer n = Integer.parseInt(gateStr);
                Intrinsics.checkNotNullExpressionValue((Object)markedTag, (String)"markedTag");
                allMarked.put(n, CollectionsKt.toMutableSet((Iterable)HexalNBTHelperKt.toUUIDList(NBTHelper.getListByByte((class_2487)markedTag, (String)gateStr, (byte)11))));
            }
        }
    }

    @JvmStatic
    public static final void writeToNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10569(TAG_CURRENT_GATE_NUM, currentGateNum);
        class_2487 markedTag = new class_2487();
        for (Map.Entry<Integer, Set<UUID>> entry : allMarked.entrySet()) {
            int gate = ((Number)entry.getKey()).intValue();
            Set<UUID> marked = entry.getValue();
            NBTHelper.putList((class_2487)markedTag, (String)String.valueOf(gate), (class_2499)HexalNBTHelperKt.toNbtListUUID(CollectionsKt.toList((Iterable)marked)));
        }
        NBTHelper.putCompound((class_2487)tag, (String)TAG_MARKED, (class_2487)markedTag);
        if (shouldClearOnWrite) {
            currentGateNum = 0;
            allMarked.clear();
        }
    }

    static {
        allMarked = new LinkedHashMap();
    }
}

